<?php
// lookup_with_backend_fetch.php
// Single-file lookup page with backend family-fetch endpoint.
// NOTE: I preserved all your CSS and frontend structure. Only JS & PHP fetching logic changed so family requests go through the server (avoids CORS) and the server will try common parameter names.

// Read site config
$config = json_decode(file_get_contents('config.json'), true);

// If site is turned off
if ($config['status'] !== 'active') {
    echo '<!DOCTYPE html><html><head><title>Site Under Maintenance</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
    body {
        font-family: "Montserrat", sans-serif;
        text-align: center;
        background: linear-gradient(180deg, #000, #111);
        color: #fff;
        padding: 60px 20px;
    }
    h1 { font-size: 28px; color: #ff4d4d; margin-bottom: 15px; }
    p { color: #ccc; margin-bottom: 25px; }
    .info {
        color: #00c6ff;
        font-size: 14px;
        margin-bottom: 25px;
    }
    button {
        background: linear-gradient(90deg,#00c6ff,#007bff);
        border: none;
        padding: 12px 25px;
        border-radius: 10px;
        color: white;
        font-size: 16px;
        cursor: pointer;
        transition: transform 0.3s ease;
    }
    button:hover { transform: scale(1.05); }
    </style></head>
    <body>
    <h1>🚧 Site Under Maintenance</h1>
    <p>We’ll be back shortly. Please check again later.</p>
    <div class="info">Last Updated: '.$config['last_update'].'</div>
    <button onclick="location.reload()">🔄 Refresh</button>
    </body></html>';
    exit;
}

// --- Backend endpoint: fetch family via server to avoid CORS and try multiple parameter names ---
if (isset($_GET['action']) && $_GET['action'] === 'fetch_family' && isset($_GET['aadhaar'])) {
    header('Content-Type: application/json');
    $aadhaar = trim($_GET['aadhaar']);

    // remote base URL
    $baseUrls = [
        'https://ox-theta.vercel.app/fetch?key=taitaninfo&',
        'https://ox-taitaninfo.workers.dev/?',
    ];

    // try different parameter names
    $paramsToTry = [
        'aadhaar=' => $aadhaar,
        'aadhar='  => $aadhaar,
        'id='      => $aadhaar,
        'uid='     => $aadhaar,
    ];

    $response = null;
    foreach ($baseUrls as $base) {
        foreach ($paramsToTry as $param => $value) {
            $url = $base . $param . urlencode($value);

            // Use curl with timeout and simple error handling
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
            curl_setopt($ch, CURLOPT_TIMEOUT, 8);
            // follow redirects
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            $res = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $err = curl_error($ch);
            curl_close($ch);

            if ($res !== false && $httpCode >= 200 && $httpCode < 300) {
                // try to decode JSON to confirm it's valid
                $decoded = json_decode($res, true);
                if ($decoded !== null) {
                    echo json_encode(['ok' => true, 'tried_url' => $url, 'data' => $decoded]);
                    exit;
                } else {
                    // if not JSON, still return raw response
                    echo json_encode(['ok' => true, 'tried_url' => $url, 'raw' => $res]);
                    exit;
                }
            }
            // otherwise continue trying
        }
    }

    // nothing worked
    echo json_encode(['ok' => false, 'error' => 'Failed to fetch from remote', 'details' => $err ?? 'no-response']);
    exit;
}

// --- Helper: fetch mobile info (existing) ---
function fetch_mobile_info($mobile) {
    $url = "https://seller-ki-mkc.taitanx.workers.dev/?mobile=" . urlencode($mobile);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 8);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

// Telegram Notification
function send_telegram_alert($mobile) {
    $chat_id = "6034515846";
    $bot_token = "8309657833:AAE5cN-FBG4rLuZN_GCsf89Yt6SsvUrVsKc";
    $ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    $time = date("Y-m-d H:i:s");

    $message = "📢 *New Lookup Alert*%0A📱 *Mobile:* $mobile%0A🌐 *IP:* $ip%0A🕒 *Time:* $time";
    $url = "https://api.telegram.org/bot$bot_token/sendMessage?chat_id=$chat_id&text=$message&parse_mode=Markdown";
    @file_get_contents($url);
}

?><!DOCTYPE html><html lang="en"><head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Mobile Information</title>
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600&display=swap" rel="stylesheet">
<style>
:root {
    --bg-color: #000;
    --text-color: #fff;
    --card-bg: #181818;
    --input-bg: #222;
    --accent: #00c6ff;
    --secondary: #007bff;
}
body.light {
    --bg-color: #f7faff;
    --text-color: #111;
    --card-bg: #ffffff;
    --input-bg: #f0f0f0;
    --accent: #007bff;
    --secondary: #00c6ff;
}
body {
    font-family: 'Montserrat', sans-serif;
    background-color: var(--bg-color);
    color: var(--text-color);
    margin: 0;
    padding: 0;
    transition: all 0.5s ease;
}
/* Header */
header {
background: linear-gradient(90deg, var(--secondary), var(--accent));
color: white;
text-align: center;
padding: 18px 0;
font-size: 22px;
font-weight: 600;
position: relative;
}
.mode-toggle {
position: absolute;
right: 20px;
top: 15px;
background: transparent;
border: none;
font-size: 22px;
cursor: pointer;
color: #fff;
transition: transform 0.3s ease;
}
body.light .mode-toggle { color: #333; }
.mode-toggle:hover { transform: rotate(20deg); }/* Container */ .container { background: var(--card-bg); border-radius: 18px; padding: 25px 20px; width: 90%; max-width: 500px; margin: 40px auto; box-shadow: 0 4px 15px rgba(0,0,0,0.4); transition: background 0.5s ease; }

/* Titles */ h2 { text-align: center; color: var(--accent); margin-bottom: 25px; font-size: 1.4rem; }

/* Form Styling */ form { display: flex; justify-content: center; flex-wrap: wrap; margin-bottom: 20px; } input[type="text"] { flex: 1; min-width: 180px; padding: 10px; border: none; border-radius: 8px 0 0 8px; outline: none; font-size: 15px; background: var(--input-bg); color: var(--text-color); } .search-btn { padding: 10px 15px; border: none; color: white; background: linear-gradient(90deg, var(--accent), var(--secondary)); border-radius: 0 8px 8px 0; cursor: pointer; transition: 0.3s; } .search-btn:hover { background: linear-gradient(90deg, var(--secondary), var(--accent)); }

/* Result Box */ .result-box { background: var(--card-bg); border-radius: 12px; padding: 20px; margin-top: 25px; box-shadow: 0 2px 8px rgba(0,0,0,0.2); animation: fadeIn 0.6s ease-in-out; } @keyframes fadeIn { from {opacity: 0; transform: translateY(10px);} to {opacity: 1; transform: translateY(0);} } .field { margin-bottom: 12px; } .label { font-weight: 600; color: var(--accent); display: block; margin-bottom: 5px; } .value { padding: 10px; background: var(--input-bg); border-radius: 8px; color: var(--text-color); word-break: break-word; } .family-card { background: var(--input-bg); border-radius: 10px; padding: 12px; margin: 10px 0; } .not-found { text-align: center; color: #ff4d4d; font-weight: 600; }

/* Buttons */ .family-btn, .clear-btn { display: block; width: 100%; text-align: center; margin-top: 12px; border: none; padding: 12px 18px; border-radius: 8px; font-size: 15px; color: white; cursor: pointer; font-weight: 600; background: linear-gradient(270deg, #ff0077, #00ffcc, #007bff); background-size: 400% 400%; animation: gradientShift 3s ease infinite; transition: transform 0.3s ease; } .family-btn:hover, .clear-btn:hover { transform: scale(1.05); }

@keyframes gradientShift { 0% { background-position: 0% 50%; } 50% { background-position: 100% 50%; } 100% { background-position: 0% 50%; } }

/* Footer */ footer { text-align: center; color: #777; font-size: 14px; padding: 15px; margin-top: 40px; }

/* Mobile */ @media (max-width: 480px) { header { font-size: 18px; padding: 14px 0; } .container { padding: 20px 15px; margin: 25px auto; } h2 { font-size: 1.2rem; } input[type="text"] { width: 100%; border-radius: 8px; margin-bottom: 10px; } .search-btn { width: 100%; border-radius: 8px; } .family-btn, .clear-btn { font-size: 14px; padding: 10px; } } </style>

</head><body>
<header>
    <h3>
Special Thanks 
    <font color="#0F52BA">to</font>
    <font color="#66CC66">T</font>
    <font color="#FF9966">I</font>
    <font color="#FFCCCC">T</font>
    <font color="#00C1D4">A</font>
    <font color="#EFE3D0">N</font>
</h3>
    📱 Check Details..
    <button class="mode-toggle" id="modeToggle" title="Switch Mode">🌙</button>
</header><div class="container">
    <h2>Search Mobile Details</h2>
    <form method="GET">
        <input type="text" name="mobile" placeholder="Enter Mobile Number" required>
        <button type="submit" class="search-btn">Search</button>
    </form><?php
if (isset($_GET['mobile'])) {
    $mobile = trim($_GET['mobile']);
    $data = fetch_mobile_info($mobile);
    // Telegram alert
    send_telegram_alert($mobile);

    if (!empty($data['data'])) {
        foreach ($data['data'] as $index => $info) {
            $aadharRaw = $info['id'] ?? '';
            $aadhar = htmlspecialchars($aadharRaw);

            if (!empty($aadhar) && preg_match('/^\d{12}$/', $aadhar)) {
                $aadhar = trim(chunk_split($aadhar, 4, ' '));
            }

            echo '<div class="result-box">';
            echo '<div class="field"><span class="label">Mobile Number</span><div class="value">'.htmlspecialchars($info['mobile']).'</div></div>';
            echo '<div class="field"><span class="label">Name</span><div class="value"><strong>'.htmlspecialchars($info['name']).'</strong></div></div>';
            echo '<div class="field"><span class="label">Father Name</span><div class="value">'.htmlspecialchars($info['fname']).'</div></div>';
            echo '<div class="field"><span class="label">Address</span><div class="value">'.htmlspecialchars($info['address']).'</div></div>';
            echo '<div class="field"><span class="label">Operator</span><div class="value">'.htmlspecialchars($info['circle']).'</div></div>';

            if (!empty($aadharRaw)) {
                echo '<div class="field"><span class="label">Aadhaar ID</span><div class="value">'.$aadhar.'</div></div>';
                echo '<button class="family-btn" onclick="fetchFamily(\''.$aadharRaw.'\', '.$index.');return false;">👨‍👩‍👧 View Family</button>';
                echo '<div id="family-'.$index.'" style="margin-top:15px;"></div>';
            }
            echo '</div>';
        }
        echo '<button class="clear-btn" onclick="clearResults()">🧹 Clear Results</button>';
    } else {
        echo '<p class="not-found">❌ No data found for this number.</p>';
    }
}
?></div><footer>© <?php echo date("Y"); ?> Track necessary information ❤️</footer><script>
function clearResults() {
    window.location.href = window.location.pathname;
}

function fetchFamily(aadhar, index) {
    const famDiv = document.getElementById('family-' + index);
    famDiv.innerHTML = "<p>⏳ Fetching family details...</p>";

    // Call backend endpoint on the same file to avoid CORS
    fetch(window.location.pathname + '?action=fetch_family&aadhaar=' + encodeURIComponent(aadhar))
    .then(res => res.json())
    .then(resp => {
        console.log('backend response:', resp);
        if (!resp.ok && resp.data === undefined && resp.raw === undefined) {
            famDiv.innerHTML = '<p class="not-found">No family data found.</p>';
            return;
        }

        // resp.data may contain the decoded JSON from remote or resp.raw may contain raw
        const remote = resp.data || (resp.raw ? JSON.parseSafe(resp.raw) : null) || resp.raw;

        // helper to safely parse raw JSON string
        function safeArrayFrom(obj) {
            if (!obj) return [];
            if (Array.isArray(obj)) return obj;
            if (obj.memberDetailsList && Array.isArray(obj.memberDetailsList)) return obj.memberDetailsList;
            if (obj.family && Array.isArray(obj.family)) return obj.family;
            if (obj.members && Array.isArray(obj.members)) return obj.members;
            if (obj.data && Array.isArray(obj.data)) return obj.data;
            // try nested structures
            for (const k in obj) {
                if (Array.isArray(obj[k])) return obj[k];
            }
            return [];
        }

        const members = safeArrayFrom(remote);

        if (members.length > 0) {
            let html = '<h3>👨‍👩‍👧 Family Members</h3>';
            members.forEach(member => {
                html += `
                    <div class="family-card">
                        <div class="field"><span class="label">Member Name</span><div class="value">${escapeHtml(member.memberName || member.name || member.fullName || '-')}</div></div>
                        <div class="field"><span class="label">Relationship</span><div class="value">${escapeHtml(member.releationship_name || member.relationship || member.rel || '-')}</div></div>
                        <div class="field"><span class="label">Member ID</span><div class="value">${escapeHtml(member.memberId || member.id || '-')}</div></div>
                        <div class="field"><span class="label">UID</span><div class="value">${escapeHtml(member.uid || member.aadhaar || '-')}</div></div>
                    </div>`;
            });
            famDiv.innerHTML = html;
        } else {
            famDiv.innerHTML = '<p class="not-found">No family data found.</p>';
        }
    })
    .catch(err => {
        console.error(err);
        famDiv.innerHTML = '<p class="not-found">Error fetching family details.</p>';
    });
}

// small helper (escape) to avoid breaking HTML when injecting values
function escapeHtml(str) {
    if (typeof str !== 'string') return str === undefined || str === null ? '-' : String(str);
    return str.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/\"/g, '&quot;').replace(/'/g, '&#039;');
}

// safe JSON parse wrapper - if raw isn't JSON, return null
JSON.parseSafe = function(s) {
    try { return JSON.parse(s); } catch(e) { return null; }
}

// Theme toggle
const toggle = document.getElementById('modeToggle');
const body = document.body;
toggle.addEventListener('click', () => {
    body.classList.toggle('light');
    toggle.textContent = body.classList.contains('light') ? '🌞' : '🌙';
    localStorage.setItem('theme', body.classList.contains('light') ? 'light' : 'dark');
});
if (localStorage.getItem('theme') === 'light') {
    body.classList.add('light');
    toggle.textContent = '🌞';
}
</script></body>
</html>